package agentes;

import ontologias.frutasOntology.*;

import jade.core.*;
import jade.core.behaviours.*;
import jade.lang.acl.*;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPANames;
import jade.domain.DFService;
import jade.domain.FIPAException;
 
import jade.content.*;
import jade.content.lang.*;
import jade.content.lang.sl.*;
import jade.content.onto.*;
 
 
public class Comprador extends Agent {
 
    private Codec codec = new SLCodec();
    private Ontology ontologia = frutasOntology.getInstance();
    
    //Clase setup
    protected void setup() {
    	 
        getContentManager().registerLanguage(codec);
        getContentManager().registerOntology(ontologia);
        Responder ComportamientoRespuesta;
        ComportamientoRespuesta = new  Responder(this);
        addBehaviour(ComportamientoRespuesta);
     }
 
    // Clase que describe el comportamiento que permite recibir un mensaje
    // y contestarlo
    class Responder extends SimpleBehaviour {
      private boolean finished = false;
 
      public Responder(Agent a) {
        super(a);
      }
 
      public void action() {
 
    System.out.println("\nAC: Esperando oferta del Vendedor....");
 
    MessageTemplate mt = MessageTemplate.and(
            MessageTemplate.MatchLanguage(codec.getName()),
            MessageTemplate.MatchOntology(ontologia.getName()));
        ACLMessage  msg = blockingReceive(mt);
 
        try {
 
        if(msg != null){
        if(msg.getPerformative() == ACLMessage.NOT_UNDERSTOOD){
                System.out.println("AC: Mensaje NOT UNDERSTOOD recibido");
            }
        else{
            if(msg.getPerformative()== ACLMessage.INFORM){
 
            ContentElement ce = getContentManager().extractContent(msg);
            if (ce instanceof Oferta){
                // Recibido un INFORM con contenido correcto
                Oferta of = (Oferta) ce;
                Fruta fru = of.getFruta();
                System.out.println("AC: Mensaje recibido:");
                System.out.println("AC: Nombre: " + fru.getNombre());
                System.out.println("AC: Precio: " + fru.getPrecio());
 
                //Tomamos decision
                System.out.println("Pensando... ");
                drools.motorDrools motorInferencia = new drools.motorDrools();
                fru.setAgente(myAgent); //Asociamos el agente a la fruta
                fru.setMensaje(msg);//Asociamos el mensaje a la fruta
                motorInferencia.insertarHecho(fru, 0); //Insertamos el hecho
            
            }
            else{
                // Recibido un INFORM con contenido incorrecto
                ACLMessage reply = msg.createReply();
                reply.setPerformative(ACLMessage.NOT_UNDERSTOOD);
                reply.setContent("( UnexpectedContent (expected ping))");
                send(reply);
            }
            }
            else {
                // Recibida una performativa incorrecta
                ACLMessage reply = msg.createReply();
                reply.setPerformative(ACLMessage.NOT_UNDERSTOOD);
                reply.setContent("( (Unexpected-act "+ACLMessage.getPerformative(msg.getPerformative())+")( expected (inform)))");
                send(reply);
            }
        }
        }else{
        //System.out.println("No message received");
        }
 
         }
         catch (jade.content.lang.Codec.CodecException ce) {
               System.out.println(ce);
        }
        catch (jade.content.onto.OntologyException oe) {
            System.out.println(oe);
        }
     }
 
      public boolean done() {
        return finished;
      }
 
  } //Fin de la clase Responder
 

}
